;Fountain pump inverter
;
;written by: Andrew bennett
;
;12F675 functions as H-bridge driver.
;PWM sinewave generation of AC to driver the sychronous motor pump
;Measuring solar panel voltage via a voltage divider 15k + 3.9k
;division of 3.9/(15 + 3.9) = 0.206
;1:4.846x
;
;-------------------------------------------------------------------
;CPU clock is internal 4MHz oscillator
;-------------------------------------------------------------------
        #include p12f675.inc
        list    p=12f675
        radix   hex
;-------------------------------------------------------------------
;configuration bits
         __CONFIG (_INTRC_OSC_NOCLKOUT & _WDT_OFF & _CP_OFF & _PWRTE_ON & _BODEN_OFF & _CPD_OFF & _MCLRE_OFF)
;-------------------------------------------------------------------
;       cpu equates (memory map)
;
; 64 General purpose register start at 20h (dec 32) in 12F675, in bank 0
;
temp_w 		equ			d'32'
temp_s		equ			d'33'
;
delay46		equ			d'34'
delay1		equ			d'35'	
delay5		equ			d'36'
;
NumH		equ			d'37'
NumL		equ			d'38'
;
Ones		equ			d'39'
Tens		equ			d'40'
Hund		equ			d'41'
Thou		equ			d'42'
TenK		equ			d'43'
;
ADC_L		equ			d'44'
ADC_H		equ			d'45'
;
dec_cnt		equ			d'46'
adc_cnt		equ			d'47'
countlow	equ			d'48'
flags		equ			d'49'
chg_state	equ			d'50'
chg_cnt		equ			d'51'	
;																
rs232_out	equ			d'52'
;
;
;
;
;
;40Hz	7.5(UV)	12.5 
;45Hz	11		14
;50Hz	13.3	15.5
;55Hz	14.8	16.4
;58Hz	15.8
;
;flags
;bit 0 - conversion started
;bit 1 - test result
;
;
;------------------------------------------------------------
; Hardware connections
;
#DEFINE 	OUTPUT_A	GPIO,GPIO0 	
#DEFINE		V_RAIL		GPIO,GPIO1		;single button control
#DEFINE		BUTTON		GPIO,GPIO2
#DEFINE		NC			GPIO,GPIO3  
#DEFINE 	RUN_LED		GPIO,GPIO4
#DEFINE		OUTPUT_B	GPIO,GPIO5
	
;======================================================================================================================
		org		0x000 
		clrwdt
		bsf		STATUS,RP0			;switch to bank 1
		movlw	b'11001000'
		goto	start				;start main program

		org		0x004
		goto	iserve

start	 
		movwf	OPTION_REG			;assigned to wdt, interupt on falling edge, prescaler is 1:1

		call	0x3ff				;get factory oscilator calibration value
		movwf	OSCCAL

		clrf	TRISIO	
		bsf		V_RAIL				;set up port directions
		bsf		BUTTON
		
		movlw	b'01010010'			; select analogue input AN1, ADC clock is Fosc/16
		movwf	ANSEL	

		clrf	WPU					;disable weak pullups
			
		clrf	PIE1

		bcf		STATUS,RP0			;switch back to bank 0
		
		movlw	b'00000111'			;turn comparator feature off
     	movwf	CMCON

		movlw	b'10000101'			;right justified, AN1 is the single analogue input, ADC module is powered up
        movwf	ADCON0
		call	del_5

		clrf	INTCON		

UV_lockout
		bcf		RUN_LED				;initalise: Run led off, H bridge off
		bcf		OUTPUT_A
		bcf		OUTPUT_B

;off_wait
;		btfsc	BUTTON
;		goto	off_wait



check_UV
		bsf		ADCON0,GO

UV_lockout_wait
		btfsc	ADCON0,GO
		goto	UV_lockout_wait

		movf	ADRESH,W
		movwf	ADC_H


		bsf		STATUS,RP0
		movf	ADRESL,W	
		bcf		STATUS,RP0
		movwf	ADC_L

		movlw	d'150'					;switch on 406 threshhold Vrail = 9.78
		movwf	NumL					;low byte, 16 bit number 
		movlw	d'1'					
		movwf	NumH					;high byte 256

		call	Sub_16		

		skpc							;NOT CARRY, inverted logic
		goto	V_over_7.3			;result greater than 1004, sample again at low gain

		call	del_5
		call	del_5
		call	del_5
		call	del_5
		
		goto	check_UV				;check for UV after 20ms
		



V_over_7.3
		bsf		RUN_LED
		movlw	d'45'
		movwf	adc_cnt


pwm_loop_40Hz
		call	del_1
		call	del_1
		call	del_1
		call	del_1

		bsf		OUTPUT_A
		call	del_46
		call	del_46
		call	del_46
		call	del_46
		call	del_46		
		call	del_46
		call	del_46
		call	del_46
		call	del_46
		call	del_46
		call	del_1
		call	del_1				
		call	del_1
		call	del_5
		bcf		OUTPUT_A

		call	del_1
		call	del_1
		call	del_1
		call	del_1


		bsf		OUTPUT_B
		call	del_46
		call	del_46
		call	del_46
		call	del_46
		call	del_46		
		call	del_46
		call	del_46
		call	del_46
		call	del_46
		call	del_46
		call	del_1
		call	del_1				
		call	del_1
		call	del_5
		bcf		OUTPUT_B

		decfsz	adc_cnt,F		
		goto	pwm_loop_40Hz


		bsf		ADCON0,GO

Vrail_low_wait
		btfsc	ADCON0,GO
		goto	Vrail_low_wait

		movf	ADRESH,W
		movwf	ADC_H

		bsf		STATUS,RP0
		movf	ADRESL,W	
		bcf		STATUS,RP0
		movwf	ADC_L

		movlw	d'54'					;lockout thershold 310 Vrail = 7.5
		movwf	NumL					;low byte, 16 bit number 
		movlw	d'1'					
		movwf	NumH					;high byte 256

		call	Sub_16		

		skpc							;NOT CARRY, inverted logic
		goto	next_freq_40Hz			;check for voltage higher for this frequency

		goto	UV_lockout

next_freq_40Hz
		movlw	d'7'					;high voltage thershold 519 Vrail = 12.48
		movwf	NumL					;low byte, 16 bit number 
		movlw	d'2'					
		movwf	NumH					;high byte 512

		call	Sub_16		

		skpc							;NOT CARRY, inverted logic
		goto	start_pwm_45		

		movlw	d'4'
		movwf	adc_cnt
		goto	pwm_loop_40Hz





start_pwm_45							
		movlw	d'50'					;1 second to stabilize the dynamics 
		movwf	adc_cnt


pwm_loop_45Hz
		call	del_1
		call	del_1				
		call	del_1
		call	del_46
		call	del_46

		bsf		OUTPUT_A
		call	del_5
		call	del_1
		call	del_1
		call	del_1
		bcf		OUTPUT_A

		call	del_1
		call	del_1				
		call	del_1
		call	del_46
		call	del_46

		bsf		OUTPUT_B
		call	del_5
		call	del_1
		call	del_1
		call	del_1
		bcf		OUTPUT_B		

		decfsz	adc_cnt,F		
		goto	pwm_loop_45Hz


		bsf		ADCON0,GO

V45Hz_wait
		btfsc	ADCON0,GO
		goto	V45Hz_wait

		movf	ADRESH,W
		movwf	ADC_H

		bsf		STATUS,RP0
		movf	ADRESL,W	
		bcf		STATUS,RP0
		movwf	ADC_L

		movlw	d'209'					;drop to the previous freq 40Hz thershold  Vrail = 11.0
		movwf	NumL					;low byte, 16 bit number 
		movlw	d'1'					
		movwf	NumH					;high byte 256

		call	Sub_16		

		skpc							;NOT CARRY, inverted logic
		goto	next_freq_45Hz			;check for voltage higher for this frequency

		goto	V_over_7.3				;drop back to previous freq


next_freq_45Hz
		movlw	d'70'					;high voltage thershold 582 Vrail = 14.05
		movwf	NumL					;low byte, 16 bit number 
		movlw	d'2'					
		movwf	NumH					;high byte 512

		call	Sub_16		

		skpc							;NOT CARRY, inverted logic
		goto	start_pwm_50			;up to next freq		

		movlw	d'4'
		movwf	adc_cnt
		goto	pwm_loop_45Hz





start_pwm_50							
		movlw	d'55'					;1 second to stabilize the dynamics 
		movwf	adc_cnt

pwm_loop_50Hz
		call	del_1
		call	del_1				

		bsf		OUTPUT_A
		call	del_1
		call	del_1
		call	del_1
		call	del_5
		bcf		OUTPUT_A

		call	del_1
		call	del_1				
	
		bsf		OUTPUT_B
		call	del_1
		call	del_1
		call	del_1
		call	del_5
		bcf		OUTPUT_B

	
		decfsz	adc_cnt,F		
		goto	pwm_loop_50Hz


		bsf		ADCON0,GO

V50Hz_low_wait
		btfsc	ADCON0,GO
		goto	V50Hz_low_wait

		movf	ADRESH,W
		movwf	ADC_H

		bsf		STATUS,RP0
		movf	ADRESL,W	
		bcf		STATUS,RP0
		movwf	ADC_L

		movlw	d'40'					;drop to the previous freq 45Hz thershold 552 Vrail = 13.3
		movwf	NumL					;low byte, 16 bit number 
		movlw	d'2'					
		movwf	NumH					;high byte 256

		call	Sub_16		

		skpc							;NOT CARRY, inverted logic
		goto	next_freq_50Hz			;check for voltage higher for this frequency

		goto	start_pwm_45			;drop back to previous freq


next_freq_50Hz
		movlw	d'133'					;high voltage thershold 645 Vrail = 15.5
		movwf	NumL					;low byte, 16 bit number 
		movlw	d'2'					
		movwf	NumH					;high byte 512

		call	Sub_16		

		skpc							;NOT CARRY, inverted logic
		goto	start_pwm_55		

		movlw	d'4'
		movwf	adc_cnt
		goto	pwm_loop_50Hz





start_pwm_55							
		movlw	d'60'					;1 second to stabilize the dynamics 
		movwf	adc_cnt

pwm_loop_55Hz
		call	del_1
		call	del_1				
		call	del_1

		bsf		OUTPUT_A
		call	del_5
		call	del_1
		call	del_46
		call	del_46
		call	del_46
		call	del_46
		bcf		OUTPUT_A

		call	del_1
		call	del_1				
		call	del_1

		bsf		OUTPUT_B
		call	del_5
		call	del_1
		call	del_46
		call	del_46
		call	del_46
		call	del_46
		bcf		OUTPUT_B
			

		decfsz	adc_cnt,F		
		goto	pwm_loop_55Hz


		bsf		ADCON0,GO

V55Hz_wait
		btfsc	ADCON0,GO
		goto	V55Hz_wait

		movf	ADRESH,W
		movwf	ADC_H

		bsf		STATUS,RP0
		movf	ADRESL,W	
		bcf		STATUS,RP0
		movwf	ADC_L

		movlw	d'104'					;drop to the previous freq 50Hz thershold 616 Vrail = 14.8
		movwf	NumL					;low byte, 16 bit number 
		movlw	d'2'					
		movwf	NumH					;high byte 256

		call	Sub_16		

		skpc							;NOT CARRY, inverted logic
		goto	next_freq_58Hz			;check for voltage higher for this frequency

		goto	start_pwm_50			;drop back to previous freq 50 Hz

next_freq_58Hz
		movlw	d'170'					;high voltage thershold 681 Vrail = 16.4
		movwf	NumL					;low byte, 16 bit number 
		movlw	d'2'					
		movwf	NumH					;high byte 512

		call	Sub_16		

		skpc							;NOT CARRY, inverted logic
		goto	start_pwm_58

		movlw	d'4'
		movwf	adc_cnt
		goto	pwm_loop_55Hz




start_pwm_58							
		movlw	d'65'					;1 second to stabilize the dynamics 
		movwf	adc_cnt

pwm_loop_58Hz
		call	del_1
		call	del_1				
		call	del_46
		call	del_46
		call	del_46
		call	del_46
		call	del_46
		call	del_46
		call	del_46
		call	del_46

		bsf		OUTPUT_A
		call	del_5
		call	del_1
		bcf		OUTPUT_A

		call	del_1
		call	del_1				
		call	del_46
		call	del_46
		call	del_46
		call	del_46
		call	del_46
		call	del_46
		call	del_46
		call	del_46

		bsf		OUTPUT_B
		call	del_5
		call	del_1
		bcf		OUTPUT_B

		decfsz	adc_cnt,F		
		goto	pwm_loop_58Hz


		bsf		ADCON0,GO

V58Hz_wait
		btfsc	ADCON0,GO
		goto	V58Hz_wait

		movf	ADRESH,W
		movwf	ADC_H

		bsf		STATUS,RP0
		movf	ADRESL,W	
		bcf		STATUS,RP0
		movwf	ADC_L

		movlw	d'145'					;drop to the previous freq 55Hz thershold  Vrail = 15.8
		movwf	NumL					;low byte, 16 bit number 
		movlw	d'2'					
		movwf	NumH					;high byte 256

		call	Sub_16		

		skpc							;NOT CARRY, inverted logic
		goto	pwm_loop_58Hz			;check for voltage higher for this frequency

		goto	start_pwm_55			;drop back to previous freq 50 Hz
;
;------------------------------------------------------------
iserve	retfie
;------------------------------------------------------------
Sub_16

	movf	ADC_L,W
	subwf	NumL,F		;f00-f02 (STATUS,C=!BORROW)
	movf	ADC_H,W
	btfss	STATUS,C	;skip if borrow=0 (C=1)
	addlw	d'01'
	subwf	NumH,F		;f01-f03	STATUS,C= !BRW   ***THIS LOGIC IS INVERTED***
	btfsc	STATUS,Z	;skip if MSbyte<>zero
	movf	NumL,F		;else, check LSbyte for zero.

	return
;------------------------------------------------------------
bin2bcd
		clrf	Ones	
		clrf	Tens
		clrf	Hund
		clrf	Thou
		clrf	TenK

		swapf	NumH,W	;w  = A2*16+A3
        andlw   d'15'   ;w  = A3		*** PERSONALLY, I'D REPLACE THESE 2
        addlw   d'240'	;w  = A3-16		*** LINES WITH "IORLW b'11110000B' " -AW
        movwf   Thou	;B3 = A3-16
        addwf   Thou,F	;B3 = 2*(A3-16) = 2A3 - 32
        addlw   d'226'	;w  = A3-16 - 30 = A3-46
        movwf   Hund	;B2 = A3-46
        addlw   d'50'	;w  = A3-46 + 50 = A3+4
        movwf   Ones	;B0 = A3+4

        movf    NumH,W	;w  = A3*16+A2
        andlw   d'15'	;w  = A2
        addwf   Hund,F	;B2 = A3-46 + A2 = A3+A2-46
        addwf   Hund,F	;B2 = A3+A2-46  + A2 = A3+2A2-46
        addwf   Ones,F	;B0 = A3+4 + A2 = A3+A2+4
        addlw   d'233'	;w  = A2 - 23
        movwf   Tens	;B1 = A2-23
        addwf   Tens,F	;B1 = 2*(A2-23)
        addwf   Tens,F	;B1 = 3*(A2-23) = 3A2-69 (Doh! thanks NG)

        swapf   NumL,W	;w  = A0*16+A1
        andlw   d'15'	;w  = A1
        addwf   Tens,F	;B1 = 3A2-69 + A1 = 3A2+A1-69 range -69...-9
        addwf   Ones,F	;B0 = A3+A2+4 + A1 = A3+A2+A1+4 and Carry = 0 (thanks NG)

        rlf     Tens,F	;B1 = 2*(3A2+A1-69) + C = 6A2+2A1-138 and Carry is now 1 as tens register had to be negitive
        rlf     Ones,F	;B0 = 2*(A3+A2+A1+4) + C = 2A3+2A2+2A1+9 (+9 not +8 due to the carry from prev line, Thanks NG)
        comf    Ones,F	;B0 = ~(2A3+2A2+2A1+9) = -2A3-2A2-2A1-10 (ones complement plus 1 is twos complement. Thanks SD)
;;Nikolai Golovchenko [golovchenko at MAIL.RU] says: comf can be regarded like:
;;      comf Ones, f
;;      incf Ones, f
;;      decf Ones, f
;;First two instructions make up negation. So,
;;Ones  = -1 * Ones - 1 
;;      = - 2 * (A3 + A2 + A1) - 9 - 1 
;;      = - 2 * (A3 + A2 + A1) - 10

        rlf     Ones,F	;B0 = 2*(-2A3-2A2-2A1-10) = -4A3-4A2-4A1-20

        movf    NumL,W	;w  = A1*16+A0
        andlw   d'15'	;w  = A0
        addwf   Ones,F	;B0 = -4A3-4A2-4A1-20 + A0 = A0-4(A3+A2+A1)-20 range -215...-5 Carry=0
        rlf     Thou,F	;B3 = 2*(2A3 - 32) = 4A3 - 64

        movlw   d'7'	;w  = 7
        movwf   TenK	;B4 = 7

;B0 = A0-4(A3+A2+A1)-20	;-5...-200
;B1 = 6A2+2A1-138	;-18...-138
;B2 = A3+2A2-46		;-1...-46
;B3 = 4A3-64		;-4...-64
;B4 = 7			;7
; At this point, the original number is
; equal to TenK*10000+Thou*1000+Hund*100+Tens*10+Ones 
; if those entities are regarded as two's compliment 
; binary.  To be precise, all of them are negative 
; except TenK.  Now the number needs to be normal- 
; ized, but this can all be done with simple byte 
; arithmetic.

		movlw   d'10'	;w  = 10
Lb1:					;do
		addwf   Ones,F	; B0 += 10
		decf    Tens,F	; B1 -= 1
		skpc			;skip on carry
		goto	Lb1		; while B0 < 0
						;jmp carry

Lb2:					;do
		addwf   Tens,F	; B1 += 10
		decf    Hund,F	; B2 -= 1
		skpc			;skip on carry
		goto	Lb2		; while B1 < 0

Lb3:					;do
		addwf   Hund,F	; B2 += 10
		decf    Thou,F	; B3 -= 1
		skpc			;skip on carry
		goto	Lb3		; while B2 < 0

Lb4:					;do
		addwf   Thou,F	; B3 += 10
		decf    TenK,F	; B4 -= 1
		skpc			;skip on carry
		goto	Lb4		; while B3 < 0

		retlw   d'0'
;------------------------------------------------------------
debounce
        call    del_5				;wait 15ms
        call    del_5
        call    del_5

        btfss   BUTTON      		;is button released?
        goto    debounce    		;wait till it is 


		call    del_5				;wait 15ms
        call    del_5
        call    del_5

        btfss   BUTTON      		;is button still released?
        goto    debounce     		;wait till it is             


        return
;------------------------------------------------------------
del_46	movlw	d'13'	   ;approx dec 13x3 + 7 cycles(div by 1 instructions per microseconds)
		movwf	delay46	   ;load counter          ***46uS delay 3N + 7 instruction cycles

delay_46
		decfsz	delay46,F	;decrement counter
		goto	delay_46	;not 0

		return		   ;counter 0, ends delay									
;------------------------------------------------------------
del_1	movlw	d'22'	   ;count 22
		movwf	delay1	   ;to counter

delay_1	call	del_46  ;delay 45 microseconds
		decfsz	delay1,F   ;do it 22 times = 1.0148 milliseconds
		goto	delay_1

		return		   ;counter 0, ends delay
;------------------------------------------------------------
del_5	movlw	d'109'	   ;count 109
		movwf	delay5	   ;to counter

delay_5	call	del_46	   ;delay 46 microseconds
		decfsz	delay5,F   ;do it 109 times = 4.988 milliseconds
		goto	delay_5

		return		   ;counter 0, ends delay
;-----------------------------------------------------------------------
		end
;-----------------------------------------------------------------------
